%This script generates Fig. 9, composed of four panels:

%Panel A: Average quoted spread for different tick sizes, in the
%experiments vs. in the Glosten-Milgrom benchmark. Beta is equal to
%8.10^(-5) in all experiments.

%Panel B: Average realized spread for different tick sizes, in the
%experiments vs. in the Glosten-Milgrom benchmark. Beta is equal to
%8.10^(-5) in all experiments.

%Panel C: Average quoted spread for different tick sizes, in the
%experiments vs. in the Glosten-Milgrom benchmark. Beta adjusts to the
%tick size so that the expected number of experimentations per price stays the same.

%Panel D: Average realized spread for different tick sizes, in the
%experiments vs. in the Glosten-Milgrom benchmark. Beta adjusts to the
%tick size so that the expected number of experimentations per price stays the same.


%%Panels A and B

%Pre-allocate a 5*2 matrix with 5 lines corresponding to 5 values of tick
%and 2 columns with the averages of QS, RS.

mat_av = zeros(5,2);

%Pre-allocate a 5*2 matrix with 5 lines corresponding to 5 values of tick
%and 2 columns with the standard deviations/sqrt(observations) of QS, RS.
mat_sd = zeros(5,2);

%Parameters
N = 2;

%Fill the matrix by loading the data on last episodes for every tick.

for iter = 1:5
% Create the name of the baseline case dataset to be loaded
    dataname = sprintf('Data/last_episodes_%d.txt', iter);
     % Load the workspace
    last_episodes = readmatrix(dataname);

    %Compute the quoted spread.
    QS = min(last_episodes(:,1:N),[],2) - 2;
    %Compute the realized spread in the last episode T of each experiment k. 
    %First we keep only episodes with a trade, remember column 2*N+2 of last_episodes is v_c.
    index = find(min(last_episodes(:,1:N),[],2)<last_episodes(:,2*N+2));
    %Generate matrix with only the episodes in which there is a trade
    trades = last_episodes(index,:);
    %Then we compute the realized spread in these episodes. 
    %Remember column 2*N+1 of last_episodes and trades is \tilde{v}.
    RS = min(trades(:,1:N),[],2)-trades(:,2*N+1);
    %Fill the matrix with the average of QS and RS.
    mat_av(iter,1) = mean(QS);
    mat_av(iter,2) = mean(RS);
    %Fill the matrix with 1.96*std. deviation of QS and RS, divided by the
    %square root of the number of observations (95% confidence interval,
    %central limit theorem).
    [n1,~] = size(last_episodes);
    [n2,~] = size(trades);
    mat_sd(iter,1) = 1.96*std(QS)/sqrt(n1);
    mat_sd(iter,2) = 1.96*std(RS)/sqrt(n2);
end

%Create a matrix with the theoretical values for each tick of QS and RS. The indexing is
%the same as in "mat".

mat_theory = zeros(5,2);
ask_theory = [2.69, 2.70 , 2.70 ,3.0, 3.0];

for iter = 1:5
a = ask_theory(iter);
mat_theory(iter,1) = a-2;
mat_theory(iter,2) = a-2*(1-normcdf(a-4,0,5))/(0.5*(1-normcdf(a-4,0,5))+0.5*(1-normcdf(a,0,5)));
end

%Panel A: MEAN FINAL QUOTED SPREAD
figure();
hold on;

%Adverse Selection
%Average
plot(1:5, mat_av(:,1), 'b-+', 'LineWidth', 1);
%Confidence Interval
ci_qs_b = fill([1:5, flip(1:5)], [(mat_av(:,1)-mat_sd(:,1))', flip((mat_av(:,1)+mat_sd(:,1))')], 'b');
set(ci_qs_b, 'facealpha', 0.3);  % make the confidence interval transparent
%Theoretical Benchmark
plot(1:5,mat_theory(:,1) ,'--o','Color',[0.0,0.0,1.0])

set(gca,'XTick',1:1:5)
set(gca,'XTickLabel',[0.01 0.05 0.1 0.5 1.0])

ylabel("Average Quoted Spread");
% xlabel('Tick size', 'FontSize', 14); 

legend('Simulations - Adverse Selection', '95\% Confidence interval', 'Nash Equilibrium - Adverse Selection','Location', 'Northwest','Interpreter','Latex');
legend('Box','off');
ylim([0,5.5]);
hold off;

%save png
filename = sprintf('/Figures/Fig_9_a.png');
saveas(gcf, [pwd filename]);

%Panel B: MEAN FINAL REALIZED SPREAD
figure();
hold on;

%Adverse Selection
%Average
plot(1:5, mat_av(:,2), 'b-+', 'LineWidth', 1);
%Confidence Interval
ci_rs_b = fill([1:5, flip(1:5)], [(mat_av(:,2)-mat_sd(:,2))', flip((mat_av(:,2)+mat_sd(:,2))')], 'b');
set(ci_rs_b, 'facealpha', 0.3);  % make the confidence interval transparent
%Theoretical Benchmark
plot(1:5,mat_theory(:,2) ,'--o','Color',[0.0,0.0,1.0])

set(gca,'XTick',1:1:5)
set(gca,'XTickLabel',[0.01 0.05 0.1 0.5 1.0])

ylabel("Average Realized Spread");
xlabel('Tick size', 'FontSize', 14); 

legend('Simulations - Adverse Selection', '95\% Confidence interval', 'Nash Equilibrium - Adverse Selection', 'Location', 'Northwest','Interpreter','Latex');
legend('Box','off');
ylim([0,5.5]);
hold off;

%save png
filename = sprintf('/Figures/Fig_9_b.png');
saveas(gcf, [pwd filename]);

%%Panels C and D

%Pre-allocate a 5*2 matrix with 5 lines corresponding to 5 values of tick
%and 2 columns with the averages of QS, RS.

mat_av = zeros(5,2);

%Pre-allocate a 5*2 matrix with 5 lines corresponding to 5 values of tick
%and 2 columns with the standard deviations/sqrt(observations) of QS, RS.
mat_sd = zeros(5,2);

%Parameters
N = 2;

%Fill the matrix by loading the data on last episodes for every tick.

for iter = 1:5
% Create the name of the baseline case dataset to be loaded
    dataname = sprintf('Data/last_episodes_beta_%d.txt', iter);
     % Load the workspace
    last_episodes = readmatrix(dataname);

    %Compute the quoted spread.
    QS = min(last_episodes(:,1:N),[],2) - 2;
    %Compute the realized spread. First we keep only episodes with a trade,
    %remember 2*N+2 is v_c.
    index = find(min(last_episodes(:,1:N),[],2)<last_episodes(:,2*N+2));
    trades = last_episodes(index,:);
    %Then we compute the realized spread over these episodes. 2*N+1 is
    %\tilde{v}.
    RS = min(trades(:,1:N),[],2)-trades(:,2*N+1);
    %Fill the matrix with the average of QS and RS.
    mat_av(iter,1) = mean(QS);
    mat_av(iter,2) = mean(RS);
    %Fill the matrix with 1.96*std. deviation of QS and RS, divided by the
    %square root of the number of observations (95% confidence interval,
    %central limit theorem).
    [n1,~] = size(last_episodes);
    [n2,~] = size(trades);
    mat_sd(iter,1) = 1.96*std(QS)/sqrt(n1);
    mat_sd(iter,2) = 1.96*std(RS)/sqrt(n2);
end

%We create a matrix with the theoretical values for each tick of QS and RS. The indexing is
%the same as in "mat".

mat_theory = zeros(5,2);
ask_theory = [2.69, 2.70 , 2.70 ,3.0, 3.0];

for iter = 1:5
a = ask_theory(iter);
mat_theory(iter,1) = a-2;
mat_theory(iter,2) = a-2*(1-normcdf(a-4,0,5))/(0.5*(1-normcdf(a-4,0,5))+0.5*(1-normcdf(a,0,5)));
end

%Panel C: MEAN FINAL QUOTED SPREAD
figure();
hold on;

%Adverse Selection
%Average
plot(1:5, mat_av(:,1), 'b-+', 'LineWidth', 1);
%Confidence Interval
ci_qs_b = fill([1:5, flip(1:5)], [(mat_av(:,1)-mat_sd(:,1))', flip((mat_av(:,1)+mat_sd(:,1))')], 'b');
set(ci_qs_b, 'facealpha', 0.3);  % make the confidence interval transparent
%Theoretical Benchmark
plot(1:5,mat_theory(:,1) ,'--o','Color',[0.0,0.0,1.0])

set(gca,'XTick',1:1:5)
set(gca,'XTickLabel',[0.01 0.05 0.1 0.5 1.0])

ylabel("Average Quoted Spread");
xlabel('Tick size', 'FontSize', 14); 

legend('Simulations - Adverse Selection', '95\% Confidence interval', 'Nash Equilibrium - Adverse Selection','Location', 'Northwest','Interpreter','Latex');
legend('Box','off');
ylim([0,5.5]);
hold off;

%save png
filename = sprintf('/Figures/Fig_9_c.png');
saveas(gcf, [pwd filename]);

%Panel D: MEAN FINAL REALIZED SPREAD
figure();
hold on;

%Adverse Selection
%Average
plot(1:5, mat_av(:,2), 'b-+', 'LineWidth', 1);
%Confidence Interval
ci_rs_b = fill([1:5, flip(1:5)], [(mat_av(:,2)-mat_sd(:,2))', flip((mat_av(:,2)+mat_sd(:,2))')], 'b');
set(ci_rs_b, 'facealpha', 0.3);  % make the confidence interval transparent
%Theoretical Benchmark
plot(1:5,mat_theory(:,2) ,'--o','Color',[0.0,0.0,1.0])

set(gca,'XTick',1:1:5)
set(gca,'XTickLabel',[0.01 0.05 0.1 0.5 1.0])

ylabel("Average Realized Spread");
xlabel('Tick size', 'FontSize', 14); 

legend('Simulations - Adverse Selection', '95\% Confidence interval', 'Nash Equilibrium - Adverse Selection', 'Location', 'Northwest','Interpreter','Latex');
legend('Box','off');
ylim([0,5.5]);
hold off;

%save png
filename = sprintf('/Figures/Fig_9_d.png');
saveas(gcf, [pwd filename]);